/*
 * Created on Sep 8, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package Validators;
import DataClasses.*;

/**
 * @author student
 *
 * This class is being used for validating the quantity of stock owned
 * when the user wants to sell his/her stocks.
 * 
 */
public class QuantityValidator {

	private String message = "";

	/**
	 * This method is being used for getting the message if the validation
	 * was unsuccessful.
	 * @return String The message to be displayed.
	 */
	public String getMessage() {
		return message;
	}
	
	/**
	 * This method is being used for settint the error message.
	 * @param message The message to be displayed.
	 * @return void
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * This is the constructor for QuantityValidator.java
	 */
	public QuantityValidator() {
	}

	/**
	 * This method is being used for validating the quantity of the stocks owned
	 * for the given user.
	 * @param user The user whose ownership stocks quantity has to be checked.
	 * @param stock The stock which is to be sold.
	 * @return boolean Specifies whether the validation was successful. 
	 */
	public boolean validate(User_Data user, Stock_Data stock) {
		StockOwnership_Data[] owned = user.getStocksOwned();
		StockOwnership_Data tempstock = null;

		//find stock..
		for (int i = 0; i < owned.length; i++) {
			if ((owned[i].getStockCode()).equals(stock.getStockCode())) {
				tempstock = owned[i];
			}
		}

		//if stock not found..
		if (tempstock == null) {
			message = "You do not own the stock.";
			return false;
		} else {
			int qtyowned = Integer.parseInt(tempstock.getQuantityOwned());
			int qtytosell = Integer.parseInt(stock.getQuantity());
			if (qtyowned < qtytosell) {
				message = "You own less than the specified quantity of stocks.";
				return false;
			}
		}
		return true;
	}

}
